<?php
if ( !defined( 'IN_CMS' ) ) {
    exit();
}

use plugins\limit_login_attempts\models\FailedLogin;
use plugins\limit_login_attempts\models\RecognizedIP;

\IoC::resolve( 'eventmediator' )->attach( 'before_login', function( $username ) {
    $settings = \IoC::resolve( 'settings' );
    $i18n = \IoC::resolve( 'i18n' );
    $now = new \DateTimeImmutable();

    //Too many attempts : overall number of failed attempts > limit
    if ( FailedLogin::count( ['attempted_at[>]' => $now->modify( '-' . $settings['limit_login_attempts.timeframe'] . ' second' )->format( 'Y-m-d H:i:s.u' )] ) > $settings['limit_login_attempts.overall_failed_attempts_limit'] ) {

        //IP not in whitelist
        if ( !RecognizedIP::exists( ['username' => $username, 'ip_address' => inet_pton( $_SERVER['REMOTE_ADDR'] )] ) ) {

            $delay = $settings['limit_login_attempts.max_ip_address_ban_time'];
            $time = new \DateTime( FailedLogin::maximum( 'attempted_at', ['ip_address' => inet_pton( $_SERVER['REMOTE_ADDR'] ) ] ) );
            if ( $time->modify( '+' . $delay . ' second' ) > $now ) {
                $flash = new \Flash();
                $waitingTime = $time->getTimestamp() - $now->getTimestamp();
                $message = $i18n->__( 'too_many_login_attempts' ). ' ';
                if ( $waitingTime <= 60 ) {
                    $message .= $i18n->__( 'try_again_in_seconds', $waitingTime );
                } else if ( $waitingTime <= 3600 ) {
                    $message .= $i18n->__( 'try_again_in_minutes', ceil( $waitingTime / 60 ) );
                } else {
                    $message .= $i18n->__( 'try_again_in_hours', ceil( $waitingTime / 3600 ) );
                }
                $flash->error( $message );
                \IoC::resolve( 'response' )->redirect( BASE_URL . 'login' );
            }
        }
    }
    
    //Too many attempts with the same username
    if ( FailedLogin::exists( ['username' => $username] ) ) {
        $attempts = FailedLogin::count( ['username' => $username] );
        $delay = min( 2 ** ( $attempts - 1 ), $settings['limit_login_attempts.max_lockout_time'] );
        $time = new \DateTime( FailedLogin::maximum( 'attempted_at', ['username' => $username] ) );

        if ( $time->modify( '+' . $delay . ' second' ) > $now ) {
            $flash = new \Flash();
            $waitingTime = $time->getTimestamp() - $now->getTimestamp();
            $message = $i18n->__( 'too_many_login_attempts' ) . ' ';
            if ( $waitingTime <= 60 ) {
                $message .= $i18n->__( 'try_again_in_seconds', $waitingTime );
            } else if ( $waitingTime <= 3600 ) {
                $message .= $i18n->__( 'try_again_in_minutes', ceil( $waitingTime / 60 ) );
            } else {
                $message .= $i18n->__( 'try_again_in_hours', ceil( $waitingTime / 3600 ) );
            }
            $flash->error( $message );
            \IoC::resolve( 'response' )->redirect( BASE_URL . 'login' );
        }
    }

    //Too many attempts from the same IP
    if ( FailedLogin::exists( ['ip_address' => inet_pton( $_SERVER['REMOTE_ADDR'] )] ) ) {
        $attempts = FailedLogin::count( ['ip_address' => inet_pton( $_SERVER['REMOTE_ADDR'] ) ] );
        $delay = min( 2 ** ( $attempts - 1 ), $settings['limit_login_attempts.max_ip_address_ban_time'] );
        $time = new \DateTime( FailedLogin::maximum( 'attempted_at', ['ip_address' => inet_pton( $_SERVER['REMOTE_ADDR'] ) ] ) );
        
        if ( $time->modify( '+' . $delay . ' second' ) > $now ) {
            $flash = new \Flash();
            $waitingTime = $time->getTimestamp() - $now->getTimestamp();
            $message = $i18n->__( 'too_many_login_attempts' ). ' ';
            if ( $waitingTime <= 60 ) {
                $message .= $i18n->__( 'try_again_in_seconds', $waitingTime );
            } else if ( $waitingTime <= 3600 ) {
                $message .= $i18n->__( 'try_again_in_minutes', ceil( $waitingTime / 60 ) );
            } else {
                $message .= $i18n->__( 'try_again_in_hours', ceil( $waitingTime / 3600 ) );
            }
            $flash->error( $message );
            \IoC::resolve( 'response' )->redirect( BASE_URL . 'login' );
        }

    }
    
    return true;

});

\IoC::resolve( 'eventmediator' )->attach( 'login_failed', function( $username, $user ) {
    if ( !\Validator::validateIP( $_SERVER['REMOTE_ADDR'] ) ) {
        $logger = \IoC::resolve( 'logger' );
        $logger->write( sprintf( '[%s] [%s] [%s] Invalid IP address.', date( 'Y-m-d H:i:s' ), __FILE__, 'warning' ) );
    }
    $failedLogin = new FailedLogin();
    $failedLogin->username = $username;   
    $failedLogin->ip_address = $_SERVER['REMOTE_ADDR'];
    $failedLogin->attempted_at = date_format( date_create(), 'Y-m-d H:i:s.u' );
    $failedLogin->save();
    return true;
} );

\IoC::resolve( 'eventmediator' )->attach( 'after_login', function( $user ) {
    $database = \IoC::resolve( 'database' );
    $database->delete( 'failed_login', ['username' => $user->username] );

    $database->delete( 'recognized_ip', ['username' => $user->username, 'created_at[<]' => (new \DateTime())->modify( '-3 month' )->format( 'Y-m-d H:i:s.u' )] );
    
    $recognizedIP = new RecognizedIP();
    $recognizedIP->username = $user->username;
    $recognizedIP->ip_address = $_SERVER['REMOTE_ADDR'];
    $recognizedIP->save();
    return true;
} );

// $logger = \IoC::resolve( 'logger' );
// $logger->write( sprintf( '[%s] [%s] [%s] Plugin limit_login_attempts initialized.', date( 'Y-m-d H:i:s' ), __FILE__, 'info' ) );
