<?php
if ( !defined( 'IN_CMS' ) ) {
    exit();
}

$schema = \IoC::resolve( 'sqlschema' );

$schema->dropTableIfexists( 'failed_login' );
$schema->dropTableIfexists( 'recognized_ip');

$schema->createTable( 'failed_login', [
    'failed_login_id' => ['integer', ['not_null' => true, 'primary_key' => true, 'identity' => true]],
    'username' => ['varchar', ['length' => 100, 'not_null' => true]],
    'ip_address' => ['varbinary', ['length' => 16, 'default' => 'NULL']],
    'attempted_at' => ['timestamp', ['not_null' => true]]
] );

$schema->createTable( 'recognized_ip', [
    'recognized_ip_id' => ['integer', ['not_null' => true, 'primary_key' => true, 'identity' => true]],
    'username' => ['varchar', ['length' => 100, 'not_null' => true]],
    'ip_address' => ['varbinary', ['length' => 16, 'not_null' => true]],
    'created_at' => ['datetime', ['not_null' => true]]
] );

$configurationHandler = \IoC::resolve( 'databaseConfigurationHandler' );
$settings = new \Configuration( $configurationHandler );

$settings['limit_login_attempts.max_lockout_time'] = 3600;
$settings['limit_login_attempts.max_ip_address_ban_time'] = 86400;
$settings['limit_login_attempts.overall_failed_attempts_limit'] = 100;
$settings['limit_login_attempts.timeframe'] = 10800;

$configurationHandler->save();

$logger = \IoC::resolve( 'logger' );
$logger->write( sprintf( '[%s] [%s] [%s] Plugin limit_login_attempts successfully installed.', date( 'Y-m-d H:i:s' ), __FILE__, 'info' ) );

return true;
