<?php
namespace plugins\limit_login_attempts\models;

/**
 * Recognized IP model class
 * @author Jérôme Brilland
 * @version 3.0
 * @copyright (c) 2021-2023, Jérôme Brilland
 * @license http://www.gnu.org/licenses/gpl.txt GNU General Public License
 */
class RecognizedIP extends \ActiveRecord {

    protected static $tableName = 'recognized_ip';

    protected function afterFind() {
        $this->ip_address = inet_ntop( $this->ip_address );
    }

    protected function beforeSave() {
        $this->ip_address = inet_pton( $this->ip_address );
    }
}
