<?php
if ( !defined( 'IN_CMS' ) ) {
    exit();
}

$schema = \IoC::resolve( 'sqlschema' );

$schema->dropTable( 'failed_login' );
$schema->dropTable( 'recognized_ip');

$configurationHandler = \IoC::resolve( 'databaseConfigurationHandler' );
$settings = new \Configuration( $configurationHandler );

unset( $settings['limit_login_attempts.max_lockout_time'] );
unset( $settings['limit_login_attempts.max_ip_address_ban_time'] );
unset( $settings['limit_login_attempts.overall_failed_attempts_limit'] );
unset( $settings['limit_login_attempts.timeframe'] );

$configurationHandler->save();

$logger = \IoC::resolve( 'logger' );
$logger->write( sprintf( '[%s] [%s] [%s] Plugin limit_login_attempts successfully uninstalled.', date( 'Y-m-d H:i:s' ), __FILE__, 'info' ) );

return true;
