<?php
if ( !defined( 'IN_CMS' ) ) {
    exit();
}

$schema = \IoC::resolve( 'sqlschema' );

$schema->dropColumn( 'failed_login', 'ip_address' );
$schema->dropColumn( 'failed_login', 'attempted_at' );
$schema->dropColumn( 'recognized_ip', 'ip_address' );
$schema->dropColumn( 'recognized_ip', 'created_at' );

$schema->addColumn( 'failed_login', 'ip_address', 'varbinary', ['length' => 16, 'default' => 'NULL'] );
$schema->addColumn( 'failed_login', 'attempted_at', 'timestamp', ['not_null' => true] );
$schema->addColumn( 'recognized_ip', 'ip_address', 'varbinary', ['length' => 16, 'not_null' => true] );
$schema->addColumn( 'recognized_ip', 'created_at', 'datetime', ['not_null' => true] );

$logger = \IoC::resolve( 'logger' );
$logger->write( sprintf( '[%s] [%s] [%s] Plugin limit_login_attempts successfully upgraded.', date( 'Y-m-d H:i:s' ), __FILE__, 'info' ) );

return true;
