<?php
defined('ROOT') OR exit('No direct script access allowed');
include_once(THEMES . $core->getConfigVal('theme') . '/functions.php');
?>
<!DOCTYPE html>
<html lang="fr">
    <head>
        <?php eval($core->callHook('frontHead')); ?>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title><?php show::titleTag(); ?></title>
        <base href="<?php show::siteUrl(); ?>/" />
        <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
        <meta name="description" content="<?php show::metaDescriptionTag(); ?>" />
        <link rel="icon" href="<?php show::themeIcon(); ?>" />
        <?php show::linkTags(); ?>
        <?php show::scriptTags(); ?>
        <?php eval($core->callHook('endFrontHead')); ?>
    </head>
    <body>
        <div id="container">
            <div id="header">
                <div id="top_header_container">                    
                    <ul id="top_nav">
                        <li id="mobile_menu"></li>
                        <li id="top_nav_first">Je mets ce que je veux ici</li>
                        <?php eval($core->callHook('endMainNavigation')); ?>
                    </ul>
                </div>
                <div id="logo">
                    <a id="sitename" href="<?php show::siteUrl(); ?>"><img src="<?php echo THEMES . $core->getConfigVal('theme'); ?>/logo.png" alt="<?php show::siteName(); ?>" title="<?php show::siteName(); ?>"/></a>
                </div>
                <div id="navigation_container">
                    <ul id="navigation">
                        <?php
                        show::mainNavigation();
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div id="alert-msg">
        <?php show::displayMsg(); ?>
    </div>
    <div id="body">
        <div id="content" class="<?php show::pluginId(); ?>">
            <?php show::mainTitle(); ?>